## ----echo = FALSE, message = FALSE---------------------------------------
options(digits = 2)
library(strataG)

## ------------------------------------------------------------------------
data(msats.g)
msats <- stratify(msats.g, "broad")
msats <- msats[, locNames(msats)[1:4], ]

## ------------------------------------------------------------------------
numAlleles(msats)

## ------------------------------------------------------------------------
numMissing(msats)

## ------------------------------------------------------------------------
numMissing(msats, prop = TRUE)

## ------------------------------------------------------------------------
allelicRichness(msats)

## ------------------------------------------------------------------------
obsvdHet(msats)
exptdHet(msats)

## ------------------------------------------------------------------------
propUniqueAlleles(msats)

## ------------------------------------------------------------------------
theta(msats)

## ------------------------------------------------------------------------
summarizeLoci(msats)
summarizeLoci(msats, by.strata = TRUE)

## ------------------------------------------------------------------------
alleleFreqs(msats)
alleleFreqs(msats, by.strata = TRUE)

