#' strataG
#' 
#' @docType package
#' @name strataG-package
#' @aliases strataG
#' @title Summaries and population structure analyses of DNA sequence genotypic 
#'   data
#' @keywords package
NULL

#' @docType data
#' @name dolph.strata
#' @title Dolphin Genetic Stratification and Haplotypes
#' @description A data.frame of 126 samples with assignment of samples to either 
#'   broad-scale or fine-scale stratifications and mtDNA haplotype designations
#' @usage data(dolph.strata)
#' @format data.frame
#' @references Lowther-Thieleking J.L., F.I. Archer, A.R. Lang, and 
#'   D.W. Weller. 2015. Genetic variation of coastal and offshore bottlenose 
#'   dolphins, Tursiops truncatus, in the eastern North Pacific Ocean. 
#'   Marine Mammal Science 31:1-20
#' @keywords datasets
NULL

#' @docType data
#' @name dolph.msats
#' @title Dolphin Microsatellite Genotypes
#' @description A data.frame of 126 samples and 4 microsatellite loci
#' @usage data(dolph.msats)
#' @format data.frame
#' @references Lowther-Thieleking J.L., F.I. Archer, A.R. Lang, and 
#'   D.W. Weller. 2015. Genetic variation of coastal and offshore bottlenose 
#'   dolphins, Tursiops truncatus, in the eastern North Pacific Ocean. 
#'   Marine Mammal Science 31:1-20
#' @keywords datasets
NULL

#' @docType data
#' @name msats.g
#' @title Dolphin Microsatellite gtypes Object
#' @description A \linkS4class{gtypes} object of 126 samples and 4 microsatellite loci
#' @usage data(msats.g)
#' @format gtypes
#' @references Lowther-Thieleking J.L., F.I. Archer, A.R. Lang, and 
#'   D.W. Weller. 2015. Genetic variation of coastal and offshore bottlenose 
#'   dolphins, Tursiops truncatus, in the eastern North Pacific Ocean. 
#'   Marine Mammal Science 31:1-20
#' @keywords datasets
NULL

#' @docType data
#' @name dolph.seqs
#' @title Dolphin mtDNA D-loop Sequences
#' @description A list of 126 aligned control region sequences
#' @usage data(dolph.seqs)
#' @format list
#' @references Lowther-Thieleking J.L., F.I. Archer, A.R. Lang, and 
#'   D.W. Weller. 2015. Genetic variation of coastal and offshore bottlenose 
#'   dolphins, Tursiops truncatus, in the eastern North Pacific Ocean. 
#'   Marine Mammal Science 31:1-20
#' @keywords datasets
NULL

#' @docType data
#' @name dolph.haps
#' @title Dolphin mtDNA Haplotype Sequences
#' @description A list of 33 aligned d-loop haplotypes
#' @usage data(dolph.haps)
#' @format list
#' @references Lowther-Thieleking J.L., F.I. Archer, A.R. Lang, and 
#'   D.W. Weller. 2015. Genetic variation of coastal and offshore bottlenose 
#'   dolphins, Tursiops truncatus, in the eastern North Pacific Ocean. 
#'   Marine Mammal Science 31:1-20
#' @keywords datasets
NULL

#' @docType data
#' @name dloop.g
#' @title Dolphin dLoop gtypes Object
#' @description A \linkS4class{gtypes} object of 126 samples and 33 haplotypes.
#' @usage data(dloop.g)
#' @format gtypes
#' @references Lowther-Thieleking J.L., F.I. Archer, A.R. Lang, and 
#'   D.W. Weller. 2015. Genetic variation of coastal and offshore bottlenose 
#'   dolphins, Tursiops truncatus, in the eastern North Pacific Ocean. 
#'   Marine Mammal Science 31:1-20
#' @keywords datasets
NULL

#' @docType data
#' @name bowhead.snps
#' @title Bowhead Whale SNP Genotypes
#' @description A data.frame of 42 SNPs with sample ids and stratification
#' @usage data(bowhead.snps)
#' @format data.frame
#' @references Morin, P.A., Archer, F.I., Pease, V.L., Hancock-Hanser, 
#'   B.L., Robertson, K.M., Huebinger, R.M., Martien, K.K., Bickham, 
#'   J.W., George, J.C., Postma, L.D., Taylor, B.L., 2012. Empirical comparison 
#'   of single nucleotide polymorphisms and microsatellites for population and 
#'   demographic analyses of bowhead whales. 
#'   Endangered Species Research 19, 129-147.
#' @keywords datasets
NULL

#' @docType data
#' @name bowhead.snp.position
#' @title Bowhead Whale SNP Genotype Groups
#' @description A data.frame of position information for SNPs to be phased
#' @usage data(bowhead.snp.position)
#' @format data.frame
#' @references Morin, P.A., Archer, F.I., Pease, V.L., Hancock-Hanser, 
#'   B.L., Robertson, K.M., Huebinger, R.M., Martien, K.K., Bickham, 
#'   J.W., George, J.C., Postma, L.D., Taylor, B.L., 2012. Empirical comparison 
#'   of single nucleotide polymorphisms and microsatellites for population and 
#'   demographic analyses of bowhead whales. 
#'   Endangered Species Research 19, 129-147.
#' @keywords datasets
NULL