% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{v2fct}
\alias{v2fct}
\title{Character Vector to (Unordered) Factor}
\usage{
v2fct(
  v,
  order.lvl = "position",
  decreasing = FALSE,
  na.lvl = FALSE,
  check = TRUE
)
}
\arguments{
\item{v}{character vector. If it is not a character vector (e.g., factor,
numeric vector), then it is coerced to a character vector within \code{v2fct}.}

\item{order.lvl}{character vector of length 1 specifying how you want to order
the levels of the factor. The options are "alphanum", which sorts the levels
alphanumerically (with NA last); "position", which sorts the levels by the position
the level first appears; "frequency", which sorts the levels by their frequency.
If any frequencies are tied, then the ties are sorted alphanumerically (with NA last).}

\item{decreasing}{logical vector of length 1 specifying whether the ordering of the
levels should be decreasing (TRUE) rather than increasing (FALSE).}

\item{na.lvl}{logical vector of length 1 specifying if NA should be considered a level.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{v} is an atomic vector.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
factor of length = \code{length(x)} and names = \code{names(x)}.
}
\description{
\code{v2fct} converts a character vector to a (unordered) factor. It goes
beyond \code{as.factor} by allowing you to specify how you want the levels ordered
and whether you want NA treated as a level.
}
\details{
When \code{order.lvl} = "alpanum" the levels are sorted alphabetically if letters
or a combination of letters and numbers/numerals are in present in \code{v}.
If only numbers/numerals are present in \code{v}, then levels are sorted numerically.
}
\examples{
# no missing values
state_region <- as.character(state.region)
v2fct(state_region, order.lvl = "position") # in position order
v2fct(v = state_region, order.lvl = "frequency",
   decreasing = TRUE) # most frequent to least frequent
v2fct(v = state_region, order.lvl = "alphanum") # in alphanumerical order
v2fct(v = state_region, na.lvl = TRUE) # na.lvl is inert because no NAs in `v`
# with missing values
state_region <- c(NA_character_, as.character(state.region), NA_character_)
v2fct(v = state_region, order.lvl = "position", na.lvl = TRUE)
v2fct(v = state_region, order.lvl = "frequency", decreasing = TRUE, na.lvl = TRUE)
v2fct(v = state_region, order.lvl = "alphanum", na.lvl = TRUE)
identical(x = v2fct(v = state_region, order.lvl = "alphanum"),
   y = as.factor(state_region)) # equal to as.factor()
# numeric vectors
v2fct(v = round(faithful$"eruptions"), order.lvl = "position")
v2fct(v = round(faithful$"eruptions"), order.lvl = "frequency", decreasing = TRUE)
v2fct(v = round(faithful$"eruptions"), order.lvl = "alphanum")
# cnumeric vectors
cnum <- c("100","99","10","9","1","0","100","99","10","9","1","0")
factor(cnum) # not in numerical order
v2fct(v = cnum, order.lvl = "alphanum") # yes in numerical order
# ties on frequency
v2fct(v = rev(npk$"block"), order.lvl = "alphanum") # ties sorted alphanumerically
v2fct(v = rev(npk$"block"), order.lvl = "position") # no possibility of ties
}
