% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{nlay}
\alias{nlay}
\title{Number of Layers (the Third Dimension)}
\usage{
nlay(x)
}
\arguments{
\item{x}{array.}
}
\value{
The number of layers (the third dimension) of \code{x}. The structure is
an integer vector with length = 1. See details for special cases.
}
\description{
\code{nlay} returns the number of layers - the third dimension - of an array.
If the object does not have a third dimension (e.g., matrix), then the function
will return NA with typeof = integer. If the object does not have any dimensions
(e.g., atomic vector), then the function will return NULL.
}
\details{
R does not have standard terminology for the third dimension. There are several common terms
people use including "height" and "page". I personally prefer "layer" as it makes sense
whether the user visualizes the third dimension as going into/ontop a desk or into/ontop a wall.
}
\examples{
nlay(HairEyeColor)
a <- array(data = NA, dim = c(6,7,8,9))
nlay(a)
}
