% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{m2v}
\alias{m2v}
\title{Matrix to (Atomic) Vector}
\usage{
m2v(m, along = 2, use.dimnames = TRUE, sep = "_", check = TRUE)
}
\arguments{
\item{m}{matrix}

\item{along}{numeric vector of length one that is equal to either 1 or 2.
1 means that \code{m} is split along rows (i.e., dimension 1) and then concatenated.
2 means that \code{m} is split along columns (i.e., dimension 2) and then concatenated.}

\item{use.dimnames}{logical vector of length 1 that specifies whether the dimnames
of \code{m} should be used to create the names for the returned vector. If FALSE,
the returned vector will have NULL names. If TRUE, see details.}

\item{sep}{character vector of length 1 specifying the string that will separate
the rownames and colnames in the naming scheme of the return object. Note, \code{sep}
is not used if \code{use.dimnames} = FALSE.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{m} is a matrix.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
(atomic) vector of length = \code{length(m)} where the order of elements
from \code{m} has been determined by \code{along} and the names determined by
the \code{use.dimnames}, \code{dimnames(m)}, and \code{sep}. See details for when
\code{use.dimnames} = TRUE.
}
\description{
\code{m2v} converts a matrix to a (atomic) vector. The benefit of \code{m2v}
over \code{as.vector} or \code{c} is that 1) the vector can be formed along rows
as well as columns and 2) the dimnames from \code{m} can be used for the names of
the returned vector.
}
\details{
If \code{use.dimnames} = TRUE, then each element's name will be analogous to
\code{paste(rownames(m)[i], colnames(m)[j], sep = sep)}. If \code{m} does not
have rownames and/or colnames, then they will be replaced by dimension positions.
This is also true when \code{m} has only one row *and* one column. The exception
is when \code{m} has either a single row *or* single column. In these cases,
only the non-single dimension's names will be used. If \code{m} has one row,
then the names of the returned vector will be \code{colnames(m)}. If \code{m}
has one column, then the names of the returned vector will be \code{rownames(m)}.
Again, if \code{m} does not have rownames and/or colnames, then they will be
replaced by dimension positions.
}
\examples{
# general matrix
mtcars2 <- as.matrix(mtcars, rownames.force = TRUE) # to make sure dimnames stay in the example
m2v(mtcars2) # default
m2v(m = mtcars2, along = 1) # concatenate along rows
m2v(m = mtcars2, sep = ".") # change the sep of the rownames(m) and colnames(m)
m2v(m = `dimnames<-`(mtcars2, list(NULL, NULL))) # use dimension positions as dimnames
m2v(m = mtcars2, use.dimnames = FALSE) # return object has no names
# one row/column matrix
one_row <- mtcars2[1,, drop = FALSE]
m2v(one_row)
one_col <- mtcars2[, 1, drop = FALSE]
m2v(one_col)
one_all <- mtcars2[1,1, drop = FALSE]
m2v(one_all)
m2v(one_all, use.dimnames = FALSE)
}
