% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overline.R
\name{overline_intersection}
\alias{overline_intersection}
\title{Convert series of overlapping lines into a route network}
\usage{
overline_intersection(sl, attrib, fun = sum, na.zero = FALSE,
  buff_dist = 0)
}
\arguments{
\item{sl}{An \code{sf} \code{LINESTRING} object with overlapping elements}

\item{attrib}{A character vector corresponding to the variables in
\code{sl$} on which the function(s) will operate.}

\item{fun}{The function(s) used to aggregate the grouped values (default: sum).
If length of \code{fun} is smaller than \code{attrib} then the functions are
repeated for subsequent attributes.}

\item{na.zero}{Sets whether aggregated values with a value of zero are removed.}

\item{buff_dist}{A number specifying the distance in meters of the buffer to be used to crop lines before running the operation.
If the distance is zero (the default) touching but non-overlapping lines may be aggregated.}
}
\description{
This function takes overlapping \code{LINESTRING}s stored in an
\code{sf} object and returns a route network composed of non-overlapping
geometries and aggregated values.
}
\examples{
routes_fast_sf$value = 1
sl <- routes_fast_sf[4:6, ]
attrib = c("value", "length")
rnet = overline_intersection(sl = sl, attrib)
plot(rnet, lwd = rnet$value)
# A larger example
sl <- routes_fast_sf[4:7, ]
rnet = overline_intersection(sl = sl, attrib = c("value", "length"))
plot(rnet, lwd = rnet$value)
rnet_sf <- overline(routes_fast_sf[4:7, ], attrib = c("value", "length"), buff_dist = 10)
plot(rnet_sf, lwd = rnet_sf$value)

# An even larger example (not shown, takes time to run)
# rnet = overline_intersection(routes_fast_sf, attrib = c("value", "length"))
# rnet_sf <- overline(routes_fast_sf, attrib = c("value", "length"), buff_dist = 10)
# plot(rnet$geometry, lwd = rnet$value * 2, col = "grey")
# plot(rnet_sf$geometry,  lwd = rnet_sf$value, add = TRUE)
}
