% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{toptailgs}
\alias{toptailgs}
\title{Clip the first and last n metres of SpatialLines}
\usage{
toptailgs(l, toptail_dist, tail_dist = NULL)
}
\arguments{
\item{l}{A SpatialLines object}

\item{toptail_dist}{The distance (in metres) to top the line by.
Can be either a single value or a vector of the same length as the
SpatialLines object. If tail_dist is missing, is used as the tail distance.}

\item{tail_dist}{The distance (in metres) to tail the line by. Can be
either a single value or a vector of the same length as the SpatialLines
object.}
}
\description{
Takes lines and removes the start and end point, to a distance determined
by the user. Uses the geosphere::distHaversine function and requires
coordinates in WGS84 (lng/lat).
}
\examples{
data("routes_fast")
rf <- routes_fast[2:3, ]
r_toptail <- toptailgs(rf, toptail_dist = 300)
plot(rf, lwd = 3)
plot(r_toptail, col = "red", add = TRUE)
plot(cents, add = TRUE)
}
