% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hearing_program.R
\name{get_hearing_program}
\alias{get_hearing_program}
\title{Retrieve the hearing program for a specified hearing}
\usage{
get_hearing_program(hearingid = NA, good_manners = 0)
}
\arguments{
\item{hearingid}{Character string indicating the id of the hearing to retrieve.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{hearing_id} \tab Id of the hearing \cr
   \strong{hearing_type} \tab Type of hearing \cr
   \strong{committee_id} \tab Id of committee responsible for the hearing \cr
   \strong{hearing_program_date} \tab Date hearing program \cr
   \strong{hearing_program_footnote} \tab Footnote for hearing program \cr
   \strong{order_number} \tab Order number for the hearing program element \cr
   \strong{text} \tab Description of the hearing participant \cr
   \strong{time_indication} \tab Time stamp for participant hearing input \cr
   \strong{date} \tab Date of participant input in hearing \cr
}
}
\description{
A function for retrieving the hearing program for a specified hearing.
The earlier periods (around 2005 and back) are less rich with data on some variables
}
\examples{
\dontrun{
s0910 <- get_session_hearings("2009-2010")
hearing <- get_hearing_program(s0910$hearing$hearing_id[1])
head(hearing)
}


}
\seealso{
\link{get_session_hearings} \link{get_hearing_input} \link{get_written_hearing_input}
}
