% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/willoughby2006eqs.R
\name{will3_deriv_func}
\alias{will3_deriv_func}
\title{Calculate the function value and derivative for Willoughby Eqn. 3}
\usage{
will3_deriv_func(xi, eq3_right)
}
\arguments{
\item{xi}{A numerical value for \eqn{\xi} from Willoughby et al. (2006),
Eqn. 2}

\item{eq3_right}{A numerical value with the right-hand side of Willoughby
et al. (2006), Eqn. 3, the dual-exponential version. This value is
calculated at each storm observation point using the
\code{\link{will3_right}} function.}
}
\value{
A numeric vector of length two. The first value is the calculated
   value of \eqn{f'(x)} for \eqn{x = \xi}, while the second value is the
   calculated value of \eqn{f(x)} for \eqn{x = \xi}. These two values
   are used in iterating through the Newton-Raphson method to determine
   \eqn{\xi}.
}
\description{
Calculates values of both the function and the derivative of
the function for which you are trying to solve the root in Eqn. 3
(the version using the dual exponential profile) of Willoughby et al. (2006).
}
\references{
Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}
