% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_sammon.R
\name{stop_sammon}
\alias{stop_sammon}
\title{STOPS version of Sammon mapping}
\usage{
stop_sammon(
  dis,
  theta = 1,
  type = "ratio",
  ndim = 2,
  init = NULL,
  weightmat = NULL,
  itmaxi = 1000,
  ...,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "chierarchy", "cconvexity", "cstriatedness", "coutlying", "cskinniness", "csparsity",
    "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  stoptype = c("additive", "multiplicative")
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; this must be  a scalar of the lambda transformation for the observed proximities. Defaults to 1.}

\item{type}{MDS type. Ignored here.}

\item{ndim}{number of dimensions of the target space}

\item{init}{(optional) initial configuration}

\item{weightmat}{a matrix of nonnegative weights. Has no effect here.}

\item{itmaxi}{number of iterations}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{which structuredness indices to be included in the loss}

\item{strucweight}{weight to be used for the structuredness indices; ; defaults to 1/#number of structures}

\item{strucpars}{the parameters for the structuredness indices}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{stoptype}{How to construct the target function for the multi objective optimization? Either 'additive' (default) or 'multiplicative'}
}
\value{
A list with the components
   \itemize{
        \item{stress:} the stress/1 *sqrt stress(
        \item{stress.m:} default normalized stress
        \item{stoploss:} the weighted loss value
        \item{indices:} the values of the structuredness indices
        \item{parameters:} the parameters used for fitting 
        \item{fit:} the returned object of the fitting procedure  smacofx::sammon 
         \item{stopobj:} the stopobj object
}
}
\description{
Uses smacofx::sammon. The free parameter is lambda for power transformations of the observed proximities.
}
\keyword{multivariate}
