% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stlp.R
\name{plot.stlp}
\alias{plot.stlp}
\title{Plot a \code{stlp} object}
\usage{
\method{plot}{stlp}(x, tcum = TRUE, marg = TRUE, col = 1, cols = "grey", ...)
}
\arguments{
\item{x}{An object of class \code{stp}}

\item{tcum}{If \code{TRUE} (default option),
the temporal point pattern is displayed cumulatively.
A barplot is automatically plotted if there are repeated
counts (typically with discrete times).}

\item{marg}{Default to \code{TRUE}. If \code{FALSE}, only the
spatio-temporal point pattern is plotted.}

\item{col}{The color of the points. Default to \code{"black"}}

\item{cols}{The color of the linear network. Default to \code{"grey"}}

\item{...}{additional unused argument}
}
\description{
This function plots the point pattern on a linear network
 stored in the \code{stlp} object given in input,
in a three panel plot representing the \link{plot3D} of the coordinates, and the
marginal spatial and temporal coordinates.
}
\examples{


set.seed(2)
df_net <- data.frame(cbind(runif(100, 0, 0.85), runif(100, 0, 0.85), runif(100)))

stlp1 <- stp(df_net, L = chicagonet)

plot(stlp1)

}
\seealso{
\link{stp}, \link{summary.stlp}, \link{print.stlp}
}
\author{
Nicoletta D'Angelo
}
