% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{paratraceplot.svdraws}
\alias{paratraceplot.svdraws}
\title{Trace Plot of MCMC Draws from the Parameter Posteriors}
\usage{
\method{paratraceplot}{svdraws}(x, mar = c(1.9, 1.9, 1.9, 0.5),
  mgp = c(2, 0.6, 0), simobj = NULL, ...)
}
\arguments{
\item{x}{\code{svdraws} or \code{svldraws} object.}

\item{mar}{numerical vector of length 4, indicating the plot margins. See
\code{\link[graphics]{par}} for details. The default value is \code{c(1.9,
1.9, 1.9, 0.5)}, which is slightly smaller than the R-defaults.}

\item{mgp}{numerical vector of length 3, indicating the axis and label
positions. See \code{\link[graphics]{par}} for details. The default value is
\code{c(2, 0.6, 0)}, which is slightly smaller than the R-defaults.}

\item{simobj}{object of class \code{svsim} as returned by the SV simulation
function \code{\link{svsim}}. If provided, ``true'' data generating values
will be added to the plots.}

\item{\dots}{further arguments are passed on to the invoked \code{matplot}
function.}
}
\value{
Called for its side effects. Returns argument \code{x} invisibly.
}
\description{
Displays a plot of iterations vs. sampled values the parameters \code{mu},
\code{phi}, \code{sigma} (and potentially \code{nu} or \code{rho}), with a separate plot
per variable.
}
\details{
\code{paratraceplot} is modeled after \code{\link[coda]{traceplot}} in the
\code{coda} package, with very minor modifications.
}
\note{
You can call this function directly, but it is more commonly called by
the \code{\link{plot.svdraws}} method.
}
\seealso{
Other plotting: \code{\link{paradensplot}},
  \code{\link{paratraceplot}}, \code{\link{plot.svdraws}},
  \code{\link{plot.svpredict}}, \code{\link{volplot}}
}
\author{
Gregor Kastner \email{gregor.kastner@wu.ac.at}
}
\concept{plotting}
\keyword{hplot}
