% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{loadRandomEffectSamplesJson}
\alias{loadRandomEffectSamplesJson}
\title{Load Random Effect Samples from JSON}
\usage{
loadRandomEffectSamplesJson(json_object, json_rfx_num)
}
\arguments{
\item{json_object}{Object of class \code{CppJson}}

\item{json_rfx_num}{Integer index indicating the position of the random effects term to be unpacked}
}
\value{
\code{RandomEffectSamples} object
}
\description{
Load a container of random effect samples from json

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
n <- 100
p <- 10
X <- matrix(runif(n*p), ncol = p)
rfx_group_ids <- sample(1:2, size = n, replace = TRUE)
rfx_basis <- rep(1.0, n)
y <- (-5 + 10*(X[,1] > 0.5)) + (-2*(rfx_group_ids==1)+2*(rfx_group_ids==2)) + rnorm(n)
bart_model <- bart(X_train=X, y_train=y, rfx_group_ids_train=rfx_group_ids,
                   rfx_basis_train = rfx_basis, num_gfr=0, num_mcmc=10)
bart_json <- saveBARTModelToJson(bart_model)
rfx_samples <- loadRandomEffectSamplesJson(bart_json, 0)
}
