% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{expand_dims_2d}
\alias{expand_dims_2d}
\title{Ensures that input is propagated appropriately to a matrix of dimension \code{output_rows} x \code{output_cols}.}
\usage{
expand_dims_2d(input, output_rows, output_cols)
}
\arguments{
\item{input}{Input to be converted to a matrix (or passed through as-is)}

\item{output_rows}{Intended number of rows in the output array}

\item{output_cols}{Intended number of columns in the output array}
}
\value{
A matrix of dimension \code{output_rows} x \code{output_cols}
}
\description{
Ensures that input is propagated appropriately to a matrix of dimension \code{output_rows} x \code{output_cols}.
Handles the following cases:
\enumerate{
\item \code{input} is a scalar: output is simply a (\code{output_rows}, \code{output_cols}) matrix with \code{input} repeated for each element
\item \code{input} is a vector of length \code{output_rows}: output is a (\code{output_rows}, \code{output_cols}) array with \code{input} broadcast across each of \code{output_cols} columns
\item \code{input} is a vector of length \code{output_cols}: output is a (\code{output_rows}, \code{output_cols}) array with \code{input} broadcast across each of \code{output_rows} rows
\item \code{input} is a matrix of dimension (\code{output_rows}, \code{output_cols}): input is passed through as-is
All other cases throw an error.
}
}
