% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asSTMCorpus.R
\name{asSTMCorpus}
\alias{asSTMCorpus}
\title{STM Corpus Coercion}
\usage{
asSTMCorpus(documents, vocab, data = NULL, ...)
}
\arguments{
\item{documents}{A documents-by-term matrix of counts, or a set of
counts in the format returned by \code{\link{prepDocuments}}. Supported
matrix formats include \pkg{quanteda} \link[quanteda]{dfm}
and \pkg{Matrix} sparse matrix objects in \code{"dgCMatrix"} or
\code{"dgTMatrix"} format.}

\item{vocab}{Character vector specifying the words in the corpus in the
order of the vocab indices in documents. Each term in the vocabulary index
must appear at least once in the documents.  See \code{\link{prepDocuments}}
for dropping unused items in the vocabulary.  If \code{documents} is a
sparse matrix or \pkg{quanteda} \link[quanteda]{dfm} object, then \code{vocab} should not
 (and must not) be supplied.  It is contained already inside the column
 names of the matrix.}

\item{data}{An optional data frame containing the prevalence and/or content
covariates.  If unspecified the variables are taken from the active
environment.}

\item{\dots}{Additional arguments passed to or from other methods.}
}
\value{
A list with components \code{"documents"}, \code{"vocab"}, and
\code{"data"} in the form needed for further processing by the \code{stm}
function.
}
\description{
Convert a set of document term counts and associated metadata to
the form required for processing by the \code{\link{stm}} function.
}
\examples{
\donttest{
library(quanteda)
gadarian_corpus <- corpus(gadarian, text_field = "open.ended.response")
gadarian_dfm <- dfm(gadarian_corpus, 
                     remove = stopwords("english"),
                     stem = TRUE)
asSTMCorpus(gadarian_dfm)
}
}
\seealso{
\code{\link{prepDocuments}}, \code{\link{stm}}
}
