% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpoistlpp.R
\name{rpoistlpp}
\alias{rpoistlpp}
\title{Simulating spatio-temporal Poisson point processes on a linear network}
\usage{
rpoistlpp(lambda,a,b,L,check=FALSE,lmax=NULL,nsim=1)
}
\arguments{
\item{lambda}{intensity of the point process. it can be either a number, function of location and time, or an abject of class \code{stlppint}}

\item{a}{lower bound of time period}

\item{b}{upper bound of time period}

\item{L}{a linear network}

\item{check}{logical value indicating whether to check that all the (x,y) points lie inside the specified window. see \code{\link{ppp}}}

\item{lmax}{upper bound for the values of \code{labmda}. this is optional}

\item{nsim}{number of simulated patterns to generate}
}
\value{
an object of class \code{\link{stlpp}} if nsim=1, otherwise a list of objects of class \code{\link{stlpp}}.
}
\description{
This function simulates realisations of a spatio-temporal Poisson point process on a linear network.
}
\details{
This function generates realisations of a spatio-temporal poisson point process on a linear network based on an intensity function lambda and lower/upper bounds a and b.
}
\examples{
 
X <- rpoistlpp(0.2,a=0,b=5,L=easynet)
X

}
\references{
Moradi, M., & Mateu, J. (2020). First-and second-order characteristics of spatio-temporal point processes on linear networks. Journal of Computational and Graphical Statistics, 29(3), 432-443.
}
\seealso{
\code{\link{density.stlpp}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
