\name{Data.Sicopolis.model}
\alias{Data.Sicopolis.model}
\docType{data}
\title{
SICOPOLIS model ensemble output
}
\description{
Ice mass loss output from a 5-parameter ensemble of SICOPOLIS ice sheet model
}
\usage{data(Data.Sicopolis.model)}
\format{
  The format is a list containing five elements
  \describe{
     \item{$t}{ 661-element time vector for model output: (1840, 1841, ...,
 2500)}
     \item{$tunits}{Time units = "Year"}
     \item{$out}{ [1:661, 1:100] matrix of Greenland Ice Sheet mass anomaly
 with respect to year 2003. [row, col] = [time index, parameter
 index]. The vector of parameter values for columns of $out is in the $par
 element of Data.Sicopolis.par.}
     \item{$outname}{ Output name = "GIS Mass Anomaly wrt 2003"}
     \item{$outunits}{ Output units "Gt"}
 }
}
\details{
The ensemble was generated by Patrick Applegate. The ensemble varies
five important ice sheet model parameters: Flow Enhancement Factor,
Basal Sliding Factor, Geothermal Heat Flux, Snow PDD Factor, and Ice PDD Factor
}
\source{
Applegate, P. J., Kirchner, N., Stone, E. J., Keller, K., and Greve, R.,
2012, An assessment of key model parametric uncertainties in projections
of Greenland Ice Sheet behavior: The Cryosphere 6, 589-606.
}
\examples{
# Fit an emulator to the SICOPOLIS ensemble data
data(Data.Sicopolis.par)
data(Data.Sicopolis.model)
\dontrun{emulator(Data.Sicopolis.par, Data.Sicopolis.model, c(FALSE, FALSE,
FALSE, FALSE, FALSE), FALSE, 200000, 20000)}
}
\keyword{datasets}
