% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd-mm_randhie.R
\docType{data}
\name{mm_randhie}
\alias{mm_randhie}
\title{Data from the RAND Health Insurance Experiment (HIE)}
\format{
The data are a list of two data frames (or "tibbles"). The first is the baseline data.

\describe{
\item{\code{plantype}}{the plan coverage of the respondent, as a factor}
\item{\code{age}}{the age of the respondent}
\item{\code{blackhisp}}{whether the respondent is not white}
\item{\code{cholest}}{the cholesterol level of the respondent (in \code{mg/dl})}
\item{\code{educper}}{the education-level of the respondent}
\item{\code{female}}{whether the respondent is a woman}
\item{\code{ghindx}}{a general health index}
\item{\code{hosp}}{was the respondent hospitalized last year?}
\item{\code{income1cpi}}{the family/household income of the respondent, adjusted for inflation}
\item{\code{mhi}}{a mental health index}
\item{\code{systol}}{the systolic blood pressure level of the respondent (in \code{mm HG})}
}

The second is the outcome data.

\describe{
\item{\code{plantype}}{the plan coverage of the respondent, as a factor}
\item{\code{ftf}}{the number of face-to-face visits for the respondent}
\item{\code{out_inf}}{the total of out-patient expenses for the respondent}
\item{\code{totadm}}{the number of hospital admissions for the respondent}
\item{\code{tot_inf}}{the total health expenses for the respondent}
}
}
\source{
RAND Health Insurance Experiment.
}
\usage{
mm_randhie
}
\description{
These are data from the RAND Health Insurance Experiment (HIE).
People who have read \emph{Mastering 'Metrics} should recognize these data. They're
 featured prominently in that book and the authors' discussion of
 random assignment and experiments.
}
\details{
Data are already cleaned in a way that facilitates an easy
replication of Table 1.3 and a partial replication of
Table 1.4 in \emph{Mastering 'Metrics}. Check
\url{http://www.masteringmetrics.com} for more information. I want to note
that my treatment of the data leans heavily on Jeff Arnold's
treatment of it. Check \url{https://jrnold.github.io/masteringmetrics/} for
more information. Future updates to the data may pursue a more exhaustive
replication. I will only note these data are a mess and the authors of
\emph{Mastering 'Metrics} do not do a great job annotating code.
}
\keyword{datasets}
