% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{lassomodel}
\alias{lassomodel}
\title{Fits a lasso model and a lasso followed by a stepAIC algorithm.}
\usage{
lassomodel(Data, standardize = TRUE, measure = c("deviance"), nfold = 5)
}
\arguments{
\item{Data}{a data frame, as a first column should have the response variable y}

\item{standardize}{Logical flag for variable standardization, prior to fitting the model.
Default is standardize=TRUE. If variables are in the same units already, you might not
wish to standardize.}

\item{measure}{loss to use for cross-validation. measure="auc" is for two-class logistic regression only,
and gives area under the ROC curve. measure="deviance", uses the deviance for logistic regression.}

\item{nfold}{number of folds - default is 5. Although nfolds can be as large as the sample size (leave-one-out CV),
it is not recommended for large datasets. Smallest value allowable is nfolds=3}
}
\value{
a list with the coefficients in the final model for the lasso fit and also for the lasso followed by stepAIC.
}
\description{
Fits a lasso model and a lasso followed by a stepAIC algorithm.
}
\details{
the function lassomodel is a wrapper function over the glmnet::glmnet. The parameter lambda is tuned
by 10-fold cross-validation with the glmnet::cv.glmnet function.
The selected lambda is the one that gives either the minimum deviance (measure="deviance")
or the maximum auc (measure="auc") or minimum misclassification error (measure="class")
}
\examples{
set.seed(14)
beta    <- c(3, 2, -1.6, -4)
noise   <- 5
simData <- SimData(N=100, beta=beta, noise=noise, corr=FALSE)

lassofit <- lassomodel(Data=simData, measure="auc")
lassofit

lassofit2 <- lassomodel(Data=simData, measure="deviance")
lassofit2

}
\seealso{
\code{\link[glmnet]{glmnet}}
}

