summary.steeptest<- function(object, ...)
{
  # Computation of some summary statistics for the simulation and print results #
  options(digits = max(4,getOption("digits") - 4),scipen=999)
  data <- array(dim=c(object$rep,1))
  data[,1] <- object$Stpsim
  colnames(data) <- c("Stpsim")
  Stp_rightpvalue <- (sum(object$Stp <= data[,"Stpsim"])+1)/(object$rep+1)
  Stp_leftpvalue <- (sum(object$Stp >= data[,"Stpsim"])+1)/(object$rep+1)
  results <- array((c(object$Stp, Stp_rightpvalue,Stp_leftpvalue,object$rep,mean(data[,"Stpsim"]),var(data[,"Stpsim"]),
                      min(data[,"Stpsim"]),quantile(data[,"Stpsim"],.25,names=F),quantile(data[,"Stpsim"],.50,names=F),
                      quantile(data[,"Stpsim"],.75,names=F),max(data[,"Stpsim"]))),dim=c(11,1))
  dimnames(results) <- list(c("Empirical value", "Right p-value", "Left p-value", "N simulations", "Mean",
                              "Variance","Minimum", "25th Pctl","50th Pctl", "75th Pctl","Maximum"),"Stp")
  results <-round(as.data.frame(results),round(log(results[4,],10)))
  cat("    ","\n")
  if (object$method == "Dij"){
    cat("RESULTS OF STEEPNESS ANALYSIS OF THE MATRIX OF DYADIC DOMINANCES CORRECTED FOR CHANCE","\n")
    cat("=====================================================================================","\n")}
  if (object$method == "Pij"){
    cat("RESULTS OF STEEPNESS ANALYSIS OF THE MATRIX OF WIN PROPORTIONS","\n")    
    cat("==============================================================","\n")}
  cat("    ","\n")
  cat("    ","\n")
  if (object$method == "Dij")
    cat("Dij","\n")
  if (object$method == "Pij")
    cat("Pij","\n")    
  cat("===","\n")
  cat("    ","\n")
  print(object$matdom)
  cat("    ","\n")
  cat("    ","\n")
  cat("DAVID'S SCORES","\n")
  cat("==============","\n")
  cat("    ","\n")
  print(object$DS)
  cat("    ","\n")
  cat("    ","\n")
  cat("NORMALIZED DAVID'S SCORES","\n")
  cat("=========================","\n")
  cat("    ","\n")
  print(object$NormDS)
  cat("    ","\n")
  cat("    ","\n")
  cat("STEEPNESS","\n")
  cat("=========","\n")
  cat("    ","\n")
  cat("Slope (absolute) = ",object$Stp,"\n")
  cat("    ","\n")
  cat("    ","\n")
  cat("INTERCEPT","\n")
  cat("=========","\n")
  cat("    ","\n")
  cat("Intercept = ",object$interc,"\n")
  cat("    ","\n")
  cat("    ","\n")
  cat("    ","\n")
  if (object$method == "Dij")
    cat("SUMMARY STATISTICS OF THE RANDOMIZATION PROCEDURE FOR TESTING STEEPNESS BASED ON THE Dij MEASURES","\n")
  if (object$method == "Pij")
    cat("SUMMARY STATISTICS OF THE RANDOMIZATION PROCEDURE FOR TESTING STEEPNESS BASED ON THE Pij MEASURES","\n")
  cat("=================================================================================================","\n")
  print(results)
  invisible(object)
}