% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{adjacency_matrix}
\alias{adjacency_matrix}
\title{Sparse adjacency matrix between two sets of areas.}
\usage{
adjacency_matrix(dom)
}
\arguments{
\item{dom}{An \code{sf} object representing a domain of areal units.}
}
\value{
An adjacency matrix
}
\description{
A convenience function to convert output from \code{sf::st_touches}
to a sparse matrix as defined in the \code{Matrix} package.
}
\details{
Returns a matrix \code{A} whose (i,j)th entry contains a 1 if
areal units \code{dom[i,]} and \code{dom[j,]} are adjacent;
0 otherwise.
}
\examples{
data("acs_sf")
dom = acs5_2013[1:4,]
A = adjacency_matrix(dom)

}
