% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areal_spatial_bisquare.R
\name{ArealSpatialBisquareBasis}
\alias{ArealSpatialBisquareBasis}
\title{Areal Spatial Bisquare Basis}
\description{
An \code{R6Class} representing the spatial bisquare basis.
}
\section{Usage}{

\preformatted{
bs = ArealSpatialBisquareBasis$new(knots_x, knots_y, w, mc_reps)
bs$compute(dom)
bs$get_dim()
bs$get_cutpoints()
bs$get_w()
}
}

\section{Arguments}{

\itemize{
\item \code{knots_x} numeric vector; x-coordinates of knot points.
\item \code{knots_y} numeric vector; y-coordinates of knot points.
\item \code{w} numeric; radius for the basis.
\item \code{dom} an \code{sf} object; areal units to evaluate.
}
}

\section{Methods}{

\itemize{
\item \code{new} Create a new \code{ArealSpatialBisquareBasis} object.
\item \code{get_dim} Get the number of cutpoints used to construct this basis.
\item \code{get_cutpoints} Get the cutpoints used to construct this basis.
\item \code{get_w} Get the radius used to construct this basis.
\item \code{compute} Evaluate this basis on specific areal units.
}
}

\examples{
set.seed(1234)
seq_x = seq(0, 1, length.out = 3)
seq_y = seq(0, 1, length.out = 3)
knots = merge(seq_x, seq_y)

# Create a simple domain from rectangles
shape1 = matrix(c(0.0,0.0, 0.5,0.0, 0.5,0.5, 0.0,0.5, 0.0,0.0), ncol=2, byrow=TRUE)
shape2 = shape1 + cbind(rep(0.5,5), rep(0.0,5))
shape3 = shape1 + cbind(rep(0.0,5), rep(0.5,5))
shape4 = shape1 + cbind(rep(0.5,5), rep(0.5,5))
sfc = st_sfc(
   st_polygon(list(shape1)),
   st_polygon(list(shape2)),
   st_polygon(list(shape3)),
   st_polygon(list(shape4))
)
dom = st_sf(data.frame(geoid = 1:length(sfc), geom = sfc))

bs = ArealSpatialBisquareBasis$new(knots[,1], knots[,2], w = 0.5,
    mc_reps = 200)
bs$compute(dom)
bs$get_dim()
bs$get_cutpoints()
bs$get_w()

# Plot the knots and the points at which we evaluated the basis
plot(knots[,1], knots[,2], pch = 4, cex = 1.5, col = "red")
plot(dom[,1], col = NA, add = TRUE)

# Draw a circle representing the basis' radius around one of the knot points
tseq = seq(0, 2*pi, length=100) 
rad = bs$get_w()
coords = cbind(rad * cos(tseq) + seq_x[2], rad * sin(tseq) + seq_y[2])
lines(coords, col = "red")
}
