% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contingency-table.R
\name{contingency_table}
\alias{contingency_table}
\title{Contingency table analyses}
\usage{
contingency_table(
  data,
  x,
  y = NULL,
  paired = FALSE,
  type = "parametric",
  counts = NULL,
  ratio = NULL,
  alternative = "two.sided",
  digits = 2L,
  conf.level = 0.95,
  sampling.plan = "indepMulti",
  fixed.margin = "rows",
  prior.concentration = 1,
  ...
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{x}{The variable to use as the \strong{rows} in the contingency table.}

\item{y}{The variable to use as the \strong{columns} in the contingency table.
Default is \code{NULL}. If \code{NULL}, one-sample proportion test (a goodness of fit
test) will be run for the \code{x} variable.}

\item{paired}{Logical indicating whether data came from a within-subjects or
repeated measures design study (Default: \code{FALSE}).}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{counts}{The variable in data containing counts, or \code{NULL} if each row
represents a single observation.}

\item{ratio}{A vector of proportions: the expected proportions for the
proportion test (should sum to \code{1}). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
E.g., \code{ratio = c(0.5, 0.5)} for two levels,
\code{ratio = c(0.25, 0.25, 0.25, 0.25)} for four levels, etc.}

\item{alternative}{A character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed
(e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See section \emph{One-Sided CIs} in
the \href{https://easystats.github.io/effectsize/}{effectsize_CIs vignette}.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{conf.level}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}

\item{sampling.plan}{Character describing the sampling plan. Possible options
are \code{"indepMulti"} (independent multinomial; default), \code{"poisson"},
\code{"jointMulti"} (joint multinomial), \code{"hypergeom"} (hypergeometric). For
more, see \code{?BayesFactor::contingencyTableBF()}.}

\item{fixed.margin}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}

\item{prior.concentration}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
The returned tibble data frame can contain some or all of the following columns (the exact columns will depend on the statistical test):
\itemize{
\item \code{statistic}: the numeric value of a statistic
\item \code{df}: the numeric value of a parameter being modeled (often degrees
of freedom for the test)
\item \code{df.error} and \code{df}: relevant only if the statistic in question has
two degrees of freedom (e.g. anova)
\item \code{p.value}: the two-sided \emph{p}-value associated with the observed statistic
\item \code{method}: the name of the inferential statistical test
\item \code{estimate}: estimated value of the effect size
\item \code{conf.low}: lower bound for the effect size estimate
\item \code{conf.high}: upper bound for the effect size estimate
\item \code{conf.level}: width of the confidence interval
\item \code{conf.method}: method used to compute confidence interval
\item \code{conf.distribution}: statistical distribution for the effect
\item \code{effectsize}: the name of the effect size
\item \code{n.obs}: number of observations
\item \code{expression}: pre-formatted expression containing statistical details
}

For examples, see \href{https://indrajeetpatil.github.io/statsExpressions/articles/web_only/dataframe_outputs.html}{data frame output vignette}.
}
\description{
Parametric and Bayesian one-way and two-way contingency table analyses.
}
\section{Contingency table analyses}{


The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}
\subsection{two-way table}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab Design \tab Test \tab Function used \cr
   Parametric/Non-parametric \tab Unpaired \tab Pearson's chi-squared test \tab \code{stats::chisq.test()} \cr
   Bayesian \tab Unpaired \tab Bayesian Pearson's chi-squared test \tab \code{BayesFactor::contingencyTableBF()} \cr
   Parametric/Non-parametric \tab Paired \tab McNemar's chi-squared test \tab \code{stats::mcnemar.test()} \cr
   Bayesian \tab Paired \tab No \tab No \cr
}


\strong{Effect size estimation}\tabular{lllll}{
   Type \tab Design \tab Effect size \tab CI available? \tab Function used \cr
   Parametric/Non-parametric \tab Unpaired \tab Cramer's \emph{V} \tab Yes \tab \code{effectsize::cramers_v()} \cr
   Bayesian \tab Unpaired \tab Cramer's \emph{V} \tab Yes \tab \code{effectsize::cramers_v()} \cr
   Parametric/Non-parametric \tab Paired \tab Cohen's \emph{g} \tab Yes \tab \code{effectsize::cohens_g()} \cr
   Bayesian \tab Paired \tab No \tab No \tab No \cr
}

}

\subsection{one-way table}{

\strong{Hypothesis testing}\tabular{lll}{
   Type \tab Test \tab Function used \cr
   Parametric/Non-parametric \tab Goodness of fit chi-squared test \tab \code{stats::chisq.test()} \cr
   Bayesian \tab Bayesian Goodness of fit chi-squared test \tab (custom) \cr
}


\strong{Effect size estimation}\tabular{llll}{
   Type \tab Effect size \tab CI available? \tab Function used \cr
   Parametric/Non-parametric \tab Pearson's \emph{C} \tab Yes \tab \code{effectsize::pearsons_c()} \cr
   Bayesian \tab No \tab No \tab No \cr
}

}
}

\examples{
if (identical(Sys.getenv("NOT_CRAN"), "true")) {
  #### -------------------- association test ------------------------ ####

  # ------------------------ frequentist ---------------------------------

  # unpaired

  set.seed(123)
  contingency_table(
    data   = mtcars,
    x      = am,
    y      = vs,
    paired = FALSE
  )

  # paired

  paired_data <- tibble(
    response_before = structure(c(1L, 2L, 1L, 2L), levels = c("no", "yes"), class = "factor"),
    response_after = structure(c(1L, 1L, 2L, 2L), levels = c("no", "yes"), class = "factor"),
    Freq = c(65L, 25L, 5L, 5L)
  )

  set.seed(123)
  contingency_table(
    data   = paired_data,
    x      = response_before,
    y      = response_after,
    paired = TRUE,
    counts = Freq
  )

  # ------------------------ Bayesian -------------------------------------

  # unpaired

  set.seed(123)
  contingency_table(
    data = mtcars,
    x = am,
    y = vs,
    paired = FALSE,
    type = "bayes"
  )

  # paired

  set.seed(123)
  contingency_table(
    data = paired_data,
    x = response_before,
    y = response_after,
    paired = TRUE,
    counts = Freq,
    type = "bayes"
  )

  #### -------------------- goodness-of-fit test -------------------- ####

  # ------------------------ frequentist ---------------------------------

  set.seed(123)
  contingency_table(
    data   = as.data.frame(HairEyeColor),
    x      = Eye,
    counts = Freq
  )

  # ------------------------ Bayesian -------------------------------------

  set.seed(123)
  contingency_table(
    data   = as.data.frame(HairEyeColor),
    x      = Eye,
    counts = Freq,
    ratio  = c(0.2, 0.2, 0.3, 0.3),
    type   = "bayes"
  )
}
}
