% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{power.mean1}
\alias{power.mean1}
\title{Approximates the power of a one-sample t-test for a planned sample size}
\usage{
power.mean1(alpha, n, var, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{n}{planned sample size}

\item{var}{planning value of response variable variance}

\item{es}{planning value of mean minus hypothesized value}
}
\value{
Returns the approximate power of the test
}
\description{
Computes the approximate power of a one-sample t-test for a planned sample
size. For a conservatively low power approximation, set the variance
planning value to the largest value within its plausible range, and set the
effect size to a minimally interesting value.
}
\examples{
power.mean1(.05, 15, 80.5, 7)

# Should return:
#     Power
# 0.8021661


}
