% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.popsize}
\alias{ci.popsize}
\title{Confidence interval for an unknown population size}
\usage{
ci.popsize(alpha, f00, f01, f10)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of people observed in both samples}

\item{f01}{number of people observed in first sample but not second sample}

\item{f10}{number of people observed in second sample but not first sample}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of the unknown population size
\item SE - recovered standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a Wald confidence interval for an unknown population size using
mark-recapture sampling. This method assumes independence of the two
samples. This function requires the frequency counts from an incomplete
2 x 2 contingency table for the two samples (f11 is the unknown number
of people who were not observed in either sample). This method sets the
estimated odds ratio (with .5 added to each cell) to 1 and solves for
unobserved cell frequency. An approximate standard error is recovered
from the confidence interval.
}
\examples{
ci.popsize(.05, 794, 710, 741)

# Should return:
# Estimate       SE   LL   UL
#     2908 49.49071 2818 3012


}
