% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.reliability}
\alias{ci.reliability}
\title{Confidence interval for a reliability coefficient}
\usage{
ci.reliability(alpha, rel, se, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{rel}{estimated reliability}

\item{se}{standard error of reliability}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population reliability coefficient
such as Cronbach's alpha or McDonald's omega using an estimate of the
reliablity and its standard error. The standard error can be a robust
standard error or bootstrap standard error obtained from an SEM program.
}
\examples{
ci.reliability(.05, .88, .147, 100)

# Should return:
# [1,]  0.7971254 0.8931436   
 

}
