% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startup.utilities.R
\name{statnetStartupMessage}
\alias{statnetStartupMessage}
\title{Construct a "standard" startup message to be printed when the package is
loaded.}
\usage{
statnetStartupMessage(pkgname, friends = c(), nofriends = c())
}
\arguments{
\item{pkgname}{Name of the package whose information is used.}

\item{friends, nofriends}{No longer used.}
}
\value{
A string containing the startup message, to be passed to the
\code{\link[=packageStartupMessage]{packageStartupMessage()}} call or \code{NULL}, if policy
prescribes printing default startup message. (Thus, if
\code{\link[=statnetStartupMessage]{statnetStartupMessage()}} returns \code{NULL}, the calling package should
not call \code{\link[=packageStartupMessage]{packageStartupMessage()}} at all.)
}
\description{
This function uses information returned by \code{\link[=packageDescription]{packageDescription()}}
to construct a standard package startup message according to the
policy of the Statnet Project.
}
\note{
Earlier versions of this function printed a more expansive
message. This may change again as the Statnet Project policy
evolves.
}
\examples{

\dontrun{
.onAttach <- function(lib, pkg){
  sm <- statnetStartupMessage("ergm")
  if(!is.null(sm)) packageStartupMessage(sm)
}
}
}
\seealso{
\code{\link[=packageDescription]{packageDescription()}}, \code{\link[=packageStartupMessage]{packageStartupMessage()}}
}
\keyword{utilities}
