/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sample.SingleBaumInterface;
import sample.SingleBaumLevel;
import sample.SingleNodes;
import vcf.GL;

public class SingleBaum
implements SingleBaumInterface {
    private final Dag dag;
    private final GL gl;
    private final int nMarkers;
    private final int nSamplesPerIndividual;
    private final long seed;
    private final Random random;
    private final int[] node1;
    private final int[] node2;
    private final double[] nodeValue;
    private final int[][] alleles1;
    private final int[][] alleles2;
    private final SingleBaumLevel[] levels;
    private final SingleNodes fwdNodes;
    private final SingleNodes bwdNodes;
    private int windowIndex = -9999;
    private int arrayIndex = -9999;

    public SingleBaum(Dag dag, GL gL, long l, int n, boolean bl) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.dag = dag;
        this.gl = gL;
        this.nMarkers = dag.nLevels();
        this.nSamplesPerIndividual = n;
        this.seed = l;
        this.random = new Random(l);
        this.node1 = new int[n];
        this.node2 = new int[n];
        this.nodeValue = new double[n];
        this.alleles1 = new int[n][gL.nMarkers()];
        this.alleles2 = new int[n][gL.nMarkers()];
        int n2 = dag.nLevels();
        if (bl) {
            n2 = (int)Math.ceil(Math.sqrt(1 + 8 * dag.nLevels()) / 2.0) + 1;
        }
        this.levels = new SingleBaumLevel[n2];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new SingleBaumLevel(dag, gL);
        }
        this.fwdNodes = new SingleNodes();
        this.bwdNodes = new SingleNodes();
    }

    @Override
    public Dag dag() {
        return this.dag;
    }

    @Override
    public GL gl() {
        return this.gl;
    }

    @Override
    public int nSamplesPerIndividual() {
        return this.nSamplesPerIndividual;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public List<HapPair> randomSample(int n) {
        this.forwardAlgorithm(n);
        this.initSampleAlleles(this.currentLevel(), n);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            SingleBaumLevel singleBaumLevel = this.previousLevel(n);
            this.sampleAlleles(singleBaumLevel, n);
        }
        return this.hapList(n);
    }

    @Override
    public List<HapPair> randomSample(int n, double[] dArray) {
        this.checkGtProbs(dArray);
        this.forwardAlgorithm(n);
        this.initSampleAlleles(this.currentLevel(), n);
        this.setInitialBackwardNodesValues();
        this.setGtProbs(this.currentLevel(), dArray);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            SingleBaumLevel singleBaumLevel = this.previousLevel(n);
            this.sampleAlleles(singleBaumLevel, n);
            singleBaumLevel.setBackwardValues(this.bwdNodes);
            this.setGtProbs(singleBaumLevel, dArray);
        }
        return this.hapList(n);
    }

    private void checkGtProbs(double[] dArray) {
        if (dArray.length != this.gl.markers().sumGenotypes()) {
            String string = "gtProbs.length!=gl.markers().sumGenotypes()";
            throw new IllegalArgumentException(string);
        }
    }

    private void setGtProbs(SingleBaumLevel singleBaumLevel, double[] dArray) {
        int n = singleBaumLevel.marker();
        int n2 = this.gl.marker(n).nGenotypes();
        int n3 = this.gl.markers().sumGenotypes(n);
        for (int i = 0; i < n2; ++i) {
            dArray[n3 + i] = singleBaumLevel.gtProbs(i);
        }
    }

    private List<HapPair> hapList(int n) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(2 * this.nSamplesPerIndividual);
        for (int i = 0; i < this.nSamplesPerIndividual; ++i) {
            BitHapPair bitHapPair = new BitHapPair(this.gl.markers(), this.gl.samples(), n, this.alleles1[i], this.alleles2[i]);
            arrayList.add(bitHapPair);
        }
        return arrayList;
    }

    private void initSampleAlleles(SingleBaumLevel singleBaumLevel, int n) {
        int n2 = singleBaumLevel.marker();
        for (int i = 0; i < this.nSamplesPerIndividual; ++i) {
            int n3 = this.initialRandomState(singleBaumLevel);
            this.node1[i] = singleBaumLevel.parentNode1(n3);
            this.node2[i] = singleBaumLevel.parentNode2(n3);
            this.nodeValue[i] = this.parentSum(singleBaumLevel, n, n3);
            this.alleles1[i][n2] = singleBaumLevel.symbol1(n3);
            this.alleles2[i][n2] = singleBaumLevel.symbol2(n3);
        }
    }

    private int initialRandomState(SingleBaumLevel singleBaumLevel) {
        double d = this.random.nextDouble();
        double d2 = 0.0;
        int n = singleBaumLevel.size();
        for (int i = 0; i < n; ++i) {
            if (!(d <= (d2 += (double)singleBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        return singleBaumLevel.size() - 1;
    }

    private double parentSum(SingleBaumLevel singleBaumLevel, int n, int n2) {
        int n3 = singleBaumLevel.marker();
        double d = singleBaumLevel.forwardValuesSum() * singleBaumLevel.forwardValue(n2);
        int n4 = singleBaumLevel.edge1(n2);
        int n5 = singleBaumLevel.edge2(n2);
        double d2 = this.dag.condEdgeProb(n3, n4);
        double d3 = this.dag.condEdgeProb(n3, n5);
        int n6 = this.dag.symbol(n3, n4);
        int n7 = this.dag.symbol(n3, n5);
        double d4 = this.gl.gl(n3, n, n6, n7);
        return d / (d4 * d2 * d3);
    }

    private void sampleAlleles(SingleBaumLevel singleBaumLevel, int n) {
        int n2 = singleBaumLevel.marker();
        for (int i = 0; i < this.nSamplesPerIndividual; ++i) {
            int n3 = this.randomPreviousState(singleBaumLevel, this.node1[i], this.node2[i], this.nodeValue[i]);
            this.node1[i] = singleBaumLevel.parentNode1(n3);
            this.node2[i] = singleBaumLevel.parentNode2(n3);
            this.nodeValue[i] = this.parentSum(singleBaumLevel, n, n3);
            this.alleles1[i][n2] = singleBaumLevel.symbol1(n3);
            this.alleles2[i][n2] = singleBaumLevel.symbol2(n3);
        }
    }

    private int randomPreviousState(SingleBaumLevel singleBaumLevel, int n, int n2, double d) {
        double d2 = this.random.nextDouble() * d;
        double d3 = 0.0;
        int n3 = singleBaumLevel.size();
        for (int i = 0; i < n3; ++i) {
            if (n != singleBaumLevel.childNode1(i) || n2 != singleBaumLevel.childNode2(i) || !(d2 <= (d3 += (double)singleBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        return singleBaumLevel.size() - 1;
    }

    private SingleBaumLevel nextLevel() {
        ++this.arrayIndex;
        if (this.arrayIndex == this.levels.length) {
            ++this.windowIndex;
            this.arrayIndex = this.windowIndex;
        }
        return this.levels[this.arrayIndex];
    }

    private SingleBaumLevel currentLevel() {
        return this.levels[this.arrayIndex];
    }

    private SingleBaumLevel previousLevel(int n) {
        if (this.arrayIndex == this.windowIndex) {
            --this.windowIndex;
            this.arrayIndex = this.windowIndex;
            this.levels[this.arrayIndex].setChildNodes(this.fwdNodes);
            int n2 = this.levels[this.windowIndex].marker() + 1;
            int n3 = n2 + (this.levels.length - (this.windowIndex + 1));
            for (int i = n2; i < n3; ++i) {
                this.nextLevel().setForwardValues(this.fwdNodes, i, n);
            }
            return this.currentLevel();
        }
        return this.levels[--this.arrayIndex];
    }

    private void forwardAlgorithm(int n) {
        this.fwdNodes.clear();
        this.fwdNodes.sumUpdate(0, 0, 1.0f);
        this.windowIndex = -1;
        this.arrayIndex = this.levels.length - 1;
        for (int i = 0; i < this.nMarkers; ++i) {
            this.nextLevel().setForwardValues(this.fwdNodes, i, n);
        }
    }

    private void setInitialBackwardNodesValues() {
        SingleBaumLevel singleBaumLevel = this.currentLevel();
        int n = singleBaumLevel.marker();
        this.bwdNodes.clear();
        int n2 = singleBaumLevel.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.dag.childNode(n, singleBaumLevel.edge1(i));
            int n4 = this.dag.childNode(n, singleBaumLevel.edge2(i));
            this.bwdNodes.sumUpdate(n3, n4, 1.0f);
        }
        singleBaumLevel.setBackwardValues(this.bwdNodes);
    }
}

