/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.BasicSampleHapPairs;
import haplotype.HapPair;
import haplotype.HapPairs;
import java.util.List;
import vcf.Marker;
import vcf.Markers;

public final class BasicHapPairs
implements HapPairs {
    private final Markers markers;
    private final HapPair[] hapPairs;

    public BasicHapPairs(List<HapPair> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("haps.isEmpy()==true");
        }
        this.markers = BasicSampleHapPairs.checkAndExtractMarkers(list);
        this.hapPairs = list.toArray(new HapPair[0]);
    }

    @Override
    public int allele1(int n, int n2) {
        return this.hapPairs[n2].allele1(n);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.hapPairs[n2].allele2(n);
    }

    @Override
    public int allele(int n, int n2) {
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.hapPairs[n3].allele1(n);
        }
        return this.hapPairs[n3].allele2(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.hapPairs.length;
    }

    @Override
    public int nHapPairs() {
        return this.hapPairs.length;
    }

    @Override
    public Samples samples(int n) {
        return this.hapPairs[n].samples();
    }

    @Override
    public int sampleIndex(int n) {
        return this.hapPairs[n].sampleIndex();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(": nHapPairs=");
        stringBuilder.append(this.nHapPairs());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

