% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statebins.R
\name{statebins_manual}
\alias{statebins_manual}
\title{Create a new ggplot-based "statebin" chart for USA states (manually colored)}
\usage{
statebins_manual(state_data, state_col = "state", color_col = "color",
  text_color = "black", font_size = 3, state_border_col = "white",
  labels = NULL, legend_title = "Legend", legend_position = "top",
  plot_title = "", title_position = "bottom")
}
\arguments{
\item{state_data}{data frame of states and values to plot}

\item{state_col}{column name in \code{state_data} that has the states. no duplicates
and can be names (e.g. "\code{Maine}") or abbreviatons (e.g. "\code{ME}")}

\item{color_col}{column name in \code{state_data} that holds the colors to be used}

\item{text_color}{default "\code{black}"}

\item{font_size}{font size (default = \code{3})}

\item{state_border_col}{default "\code{white}" - this creates the "spaces" between boxes}

\item{labels}{labels for the legend (should be the same number as distinct colors in
\code{color_col}); \code{NULL} == no labels/legend}

\item{legend_title}{title for the legend}

\item{legend_position}{"\code{none}", "\code{top}", "\code{left}", "\code{right}" or
"\code{bottom}" (defaults to "\code{top}")}

\item{plot_title}{title for the plot}

\item{title_position}{where to put the title ("\code{bottom}" or "\code{top}" or ""
for none); if "\code{bottom}", you get back a grob vs a ggplot object}
}
\value{
ggplot2 object or grob
}
\description{
\code{statebins()} creates "statebin" charts in the style of \url{http://bit.ly/statebins}
}
\details{
This version uses manual colors (i.e. pass in a column that defines the color per-state)

The function minimally expects the caller to pass in a data frame that:

\itemize{
  \item has one column of all state abbreviationis (all caps, including \code{DC} &
    \code{PR}  or a column of state names (standard capitalization) named \code{state}
  \item has another column of colors named \code{color}
}

Doing so will create a "statebin" chart with the colors specified as a ggplot2 object.

You can use a different column for the state names and colors by changing \code{state_col}
and \code{color_col} accordingly.

To add a title, change \code{plot_title} to anything but an empty atomic string vector (i.e. \code{""})
and set \code{title_position} to "\code{top}" or "\code{bottom}". Choosing "\code{bottom}"
will cause \code{statebins} to use \code{arrangeGrob} to position the title via \code{sub} and
return a frame grob instead of a ggplot2 object.
}
\examples{
\dontrun{
library(httr)
library(dplyr)
election_2012 <-
  GET("https://raw.githubusercontent.com/hrbrmstr/statebins/master/tmp/election2012.csv")
results <- read.csv(textConnection(content(election_2012, as="text")),
                    header=TRUE, stringsAsFactors=FALSE)
results <- results \%>\%
  mutate(color=ifelse(is.na(Obama), "#2166ac", "#b2182b")) \%>\%
  select(state, color)
results \%>\%
  statebins_manual(font_size=4,
      text_color = "white", labels=c("Romney", "Obama"),
      legend_position="right", legend_title="Winner")
}
}

