% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\alias{tab_}
\title{Returns cross tabulation}
\usage{
tab(x, ...)

tab_(x, ..., .dots, i = NULL, w = NULL, na.rm = FALSE, sort = sort)
}
\arguments{
\item{x}{a vector or a data.frame}

\item{...}{Variable(s) to include. If length is two, a special cross tabulation table is printed although a long data.frame is always (invisibly) returned.}

\item{.dots}{Used to work around non-standard evaluation.}

\item{i}{Condition to apply function on certain rows only}

\item{w}{Frequency weights. Default to NULL.}

\item{na.rm}{Remove missing values. Default to FALSE}

\item{sort}{Boolean. Default to TRUE}
}
\value{
a data.frame sorted by variables in ..., and with columns "Freq.", "Percent", and "Cum." for counts.
}
\description{
Returns cross tabulation
}
\examples{
# setup
library(dplyr)
N <- 1e2 ; K = 10
df <- data_frame(
  id = sample(c(NA,1:5), N/K, TRUE),
  v1 =  sample(1:5, N/K, TRUE)                       
)
# one-way tabulation
df \%>\% tab(id)
# two-way tabulation
df \%>\% tab(id, v1)
tab(df, id, i = id>=3)
}
