% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.mult.scaling}
\alias{graph.mult.scaling}
\title{Multidimensional scaling of graphs}
\usage{
graph.mult.scaling(
  G,
  plot = TRUE,
  bandwidth = "Silverman",
  type = "n",
  main = "",
  ...
)
}
\arguments{
\item{G}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}

\item{plot}{logical. If TRUE (default) the points chosen to represent the
Jensen-Shannon divergence between graphs are plotted.}

\item{bandwidth}{string showing which criterion is used to choose the
bandwidth during the spectral density estimation. Choose between the
following criteria: "Silverman" (default), "Sturges", "bcv", "ucv" and "SJ".
"bcv" is an abbreviation of biased cross-validation, while "ucv" means
unbiased cross-validation. "SJ"  implements the methods of Sheather & Jones
(1991) to select the bandwidth using pilot estimation of derivatives.}

\item{type}{what type of plot should be drawn. The defaut value is '"n"',
which indicates that the points will not be plotted (i. e. only the labels
of the graphs will be plotted).}

\item{main}{title of the plot (default value is "").}

\item{...}{additional plotting parameters. See 'plot' function from the
'graphics' package for the complete list.}
}
\value{
A matrix in which each column corresponds to a coordinate and each
row corresponds to a graph (point). Then, each row gives the coordinates of
the points chosen to represent the Jensen-Shannon divergence between graphs.
}
\description{
\code{graph.mult.scaling} performs multidimensional scaling of graphs. It
takes the Jensen-Shannon divergence between graphs (JS) and uses the
'cmdscale' function from the 'stats' package to obtain a set of points such
that the distances between the points are similar to JS.
}
\examples{
set.seed(1)
G <- list()
for (i in 1:5) {
  G[[i]] <- igraph::sample_gnp(50, 0.5)
}
for (i in 6:10) {
  G[[i]] <- igraph::sample_smallworld(1, 50, 8, 0.2)
}
for (i in 11:15) {
  G[[i]] <- igraph::sample_pa(50, power = 1, directed = FALSE)
}
graph.mult.scaling(G)

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{multidimensional_scaling}
