% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.acf}
\alias{graph.acf}
\title{Auto Correlation Function Estimation for Graphs}
\usage{
graph.acf(G, plot = TRUE)
}
\arguments{
\item{G}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}

\item{plot}{logical. If TRUE (default) the graph.acf is plotted.}
}
\value{
An object of class acf.
}
\description{
The function \code{graph.acf} computes estimates of the autocorrelation
function for graphs.
}
\examples{
set.seed(1)
G <- list()
p <- array(0, 100)
p[1:3] <- rnorm(3)
for (t in 4:100) {
  p[t] <- 0.5*p[t-3] + rnorm(1)
}
ma <- max(p)
mi <- min(p)
p <- (p - mi)/(ma-mi)
for (t in 1:100) {
  G[[t]] <- igraph::sample_gnp(100, p[t])
}
graph.acf(G, plot=TRUE)

}
\references{
Fujita, A., Takahashi, D. Y., Balardin, J. B., Vidal, M. C. and Sato, J. R.
(2017) Correlation between graphs with an application to brain network
analysis. _Computational Statistics & Data Analysis_ *109*, 76-92.
}
\keyword{autocorrelation}
