% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{fraiman.test}
\alias{fraiman.test}
\title{Daniel Fraiman and Ricardo Fraiman test for network differences between
groups with an analysis of variance test (ANOVA).}
\usage{
fraiman.test(G, maxBoot = 300)
}
\arguments{
\item{G}{the undirected graphs to be compared. Must be a list of lists of
igraph objects or a list of lists of adjacency matrices.}

\item{maxBoot}{integer indicating the number of bootstrap resamples
(default is 300).}
}
\value{
A list containing:
\item{T}{the value of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
Given a list of graphs, the test verifies if all the subpopulations have the
same mean network, under the alternative that at least one subpopulation has
a different mean network.
}
\examples{
\dontrun{
set.seed(42)

## test under H0
a <- b <- G <- list()
for(i in 1:10){
  a[[i]] <- igraph::sample_gnp(50,0.5)
  b[[i]] <- igraph::sample_gnp(50,0.5)
}
G <- list(a,b)
k1 <- fraiman.test(G)
k1

## test under H1
a <- b <- G <- list()
for(i in 1:10){
  a[[i]] <- igraph::sample_gnp(50,0.5)
  b[[i]] <- igraph::sample_gnp(50,0.6)
}
G <- list(a,b)
k2 <- fraiman.test(G)
k2
}

}
\references{
Fraiman, Daniel, and Ricardo Fraiman. "An ANOVA approach for statistical
comparisons of brain networks",
https://www.nature.com/articles/s41598-018-23152-5
}
