% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf.R
\name{CONF}
\alias{CONF}
\alias{CONF.mean}
\alias{CONF.var}
\alias{CONF.prop}
\title{Optimal Confidence Intervals for finite populations}
\usage{
CONF.mean(
  alpha,
  x = NULL,
  sample.mean = mean(x),
  sample.variance = var(x),
  n = length(x),
  N = Inf,
  kurt = 3,
  unsampled = FALSE,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

CONF.var(
  alpha,
  x = NULL,
  sample.variance = var(x),
  n = length(x),
  N = Inf,
  kurt = NULL,
  unsampled = FALSE,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

CONF.prop(
  alpha,
  x = NULL,
  sample.prop = mean(x),
  n = length(x),
  N = Inf,
  unsampled = FALSE
)
}
\arguments{
\item{alpha}{alpha Numeric (probability) The significance level determining the confidence level for the interval (the confidence level is 1-alpha).}

\item{x}{Numeric (vector) The vector of sample data. In the CONF.prop function this must be binary data. Ignored if a sample statistic is provided.}

\item{sample.mean}{Numeric (any) The sample mean of the data.}

\item{sample.variance}{Numeric (non-neg) The sample variance of the data.}

\item{n}{Integer (positive) The sample size}

\item{N}{Integer (positive) The population size (must be at least as large as the sample size)}

\item{kurt}{Numeric (positive) The assumed kurtosis of the underlying distribution (must be at least one)}

\item{unsampled}{Logical (positive) Indicator of whether the user wants a confidence interval for the relevant parameter only for the unsampled part of the population (as opposed to the whole population)}

\item{gradtol}{Parameter for the nlm optimisation - a positive scalar giving the tolerance at which the scaled gradient is considered close enough to zero to terminate the algorithm (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{steptol}{Parameter for the nlm optimisation - a positive scalar providing the minimum allowable relative step length (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{iterlim}{Parameter for the nlm optimisation - a positive integer specifying the maximum number of iterations to be performed before the program is terminated (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{sample.prop}{Numeric (probability) The sample proportion of the data (only for binary data)}
}
\value{
an object of class 'ci' providing the confidence interval and related information.
}
\description{
These functions compute an optimised confidence interval for statistics based on a sample.  The user may enter either a
data vector \code{x} or the sample size \code{n} and the sample statistic.  By default the confidence interval is computed
for an infinite population.  However, the user may enter a population size \code{N} and may use the logical value \code{unsampled} to specify
when the confidence interval is for the variance only of the unsampled part of the population.  This test accounts for the kurtosis, and
so the user must either specify the data vector or specify an assumed kurtosis \code{kurt}; if no kurtosis value is specified then the test
uses the sample kurtosis from the data.
}
\details{
The mean interval is built on a symmetric pivotal quantity so it is symmetric around the sample mean.  

The variance interval is built on a non-symmetric pivotal quantity, so it is optimised by taking the shortest possible confidence interval with the specified confidence level (see e.g., Tate and Klett 1959).  

The proportion interval uses the Wilson score interval (see e.g., Agresti and Coull 1998).
}
\examples{
DATA <- c(17.772, 16.359, 15.734, 15.698, 16.042, 
15.527, 16.533, 15.385, 15.368, 18.603, 
15.036, 13.873, 14.329, 15.837, 14.189, 
15.398, 16.266, 12.970, 15.219, 16.444, 
11.049, 14.262);
KURT <- 4.37559247659433 # moments::kurtosis(DATA);
CONF.mean(alpha = 0.1, x = DATA, N = 3200, kurt = KURT);
CONF.var(alpha = 0.1, x = DATA, N = 3200, kurt = KURT);
CONF.prop(alpha = 0.1, x = DATA > 15, N = 3200);

}
