% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.R
\name{HDR.monotone}
\alias{HDR.monotone}
\alias{HDR.unimodal}
\alias{HDR.bimodal}
\alias{HDR.discrete.unimodal}
\alias{HDR.discrete}
\title{Custom HDR Functions}
\usage{
HDR.monotone(
  cover.prob,
  Q,
  decreasing = TRUE,
  distribution = UNSPECIFIED_LABEL,
  ...
)

HDR.unimodal(
  cover.prob,
  Q,
  f = NULL,
  u = NULL,
  distribution = UNSPECIFIED_LABEL,
  ...,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.bimodal(
  cover.prob,
  Q,
  f = NULL,
  u = NULL,
  distribution = UNSPECIFIED_LABEL,
  ...,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.discrete.unimodal(
  cover.prob,
  Q,
  F,
  f = NULL,
  u = NULL,
  distribution = UNSPECIFIED_LABEL,
  ...,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)

HDR.discrete(
  cover.prob,
  Q,
  f = NULL,
  u = NULL,
  distribution = UNSPECIFIED_LABEL,
  ...,
  gradtol = 1e-10,
  steptol = 1e-10,
  iterlim = 100
)
}
\arguments{
\item{cover.prob}{The probability coverage for the HDR (scalar between zero and one).  The significance level for the HDR i is \code{1-cover.prob}.}

\item{Q}{an inverse CDF of a distribution}

\item{decreasing}{Direction of monotone distribution}

\item{distribution}{a label}

\item{...}{Arguments for Q, f and u}

\item{f}{a PDF of a distribution}

\item{u}{a log-derivative of f}

\item{gradtol}{Parameter for the nlm optimisation - a positive scalar giving the tolerance at which the scaled gradient is considered close enough to zero to terminate the algorithm (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{steptol}{Parameter for the nlm optimisation - a positive scalar providing the minimum allowable relative step length (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{iterlim}{Parameter for the nlm optimisation - a positive integer specifying the maximum number of iterations to be performed before the program is terminated (see [\code{nlm} doccumentation](https://stat.ethz.ch/R-manual/R-patched/library/stats/html/nlm.html)).}

\item{F}{a CDF of a distribution}
}
\value{
An interval object with classes \code{hdr} and \code{interval} containing the highest density region and related information.
}
\description{
Custom HDR Functions
}
\examples{

HDR.monotone(.95, Q=qexp)

HDR.unimodal(.95, Q=qnorm)

HDR.bimodal(.95, Q=qbeta, shape1=1/2, shape2=1/2)

HDR.discrete.unimodal(.95, Q=qpois, F=ppois, lambda=1)

HDR.discrete(.95, Q=qpois, f=dpois, lambda=1)

}
