% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_aggregation.R
\name{panel_st_agg_static}
\alias{panel_st_agg_static}
\title{Create a space-time visualization with static aggregation.}
\usage{
panel_st_agg_static(
  data = NULL,
  runtime = FALSE,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end,
  expand_x = data$config$expand,
  expand_y = data$config$st$expand,
  outliers = data$config$st$outliers,
  step = data$config$st$aggregation$step
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{runtime}{if this is runtime data}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{expand_x}{expand size for scale_x_continuous padding}

\item{expand_y}{expand size for scale_y_continuous padding}

\item{outliers}{print outliers on top}

\item{step}{time-step}
}
\value{
A ggplot object
}
\description{
Use any state trace data to plot the task computations by ResourceId
over the execution time with Gantt Chart. This function aggregate
states with a static/user-defined time-step.
}
\examples{
\donttest{
panel_st_agg_static(data = starvz_sample_lu)
}
}
