% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontier.R
\name{frontier}
\alias{frontier}
\title{Find efficient frontier}
\usage{
frontier(...)
}
\arguments{
\item{...}{coordinates to scan}
}
\value{
logical vector, TRUE if point is on efficient frontier
}
\description{
A predicate that is TRUE if a point is on the efficient frontier.
}
\examples{

df <- data.frame(x=rnorm(100), y=rnorm(100))
plot(df)
points(subset(df, frontier(x,y)), col='red', pch=15)
points(subset(df, frontier(-x,y)), col='green', pch=15)
points(subset(df, frontier(x,-y)), col='blue', pch=15)
points(subset(df, frontier(-x,-y)), col='orange', pch=15)
 
}
\references{
\url{https://stackoverflow.com/a/36209989/986793}
}
\author{
\href{https://stackoverflow.com/users/986793/neal-fultz}{Neal Fultz}
}
