% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asset-valuation.R
\name{valFunction.asset}
\alias{valFunction.asset}
\title{Building the Valuation Function for Asset with Direct Market
Price}
\usage{
\method{valFunction}{asset}(object, market.risk, with.constant = T, ...)
}
\arguments{
\item{object}{S3 object of class asset.}

\item{market.risk}{S3 object of class marketRisk created using the constructor
\code{marketRisk}.}

\item{with.constant}{a logical value, should the expression be with constant (mean zero variation) or not?}

\item{...}{additional arguments.}
}
\value{
a function with one argument:
          \itemize{
            \item \code{x}: a matrix of simulations (numeric values) with named columns corresponding
              exactly to the name of base risk-factors in \code{marketRisk} keeping the
              same order, or an unnamed vector of simulations (numeric values) keeping the same
              ordering of base risk-factors as in \code{marketRisk}.
          }
}
\description{
\code{valFunction} is a generic S3 method for classes
  inheriting from item. This method returns the valuation function of an asset with direct market price called \emph{"Aktiven mit direkt marktabhängigen Preisen"}
  in the FINMA technical document \emph{"SST-Standardmodell Versicherungsmodell: Zielkapital"} (version 31.1.2018).
}
\note{
the function returns the one-year profit variation
(with mean zero or not depending on \code{with.constant}).
}
\seealso{
\code{\link{valFunction}}, \code{\link{asset}}, \code{\link{marketRisk}}.
}
