% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskFactor.R
\name{spread}
\alias{spread}
\title{Constructing a Spread (Risk Factor)}
\usage{
spread(name, currency, rating, scale = NULL)
}
\arguments{
\item{name}{a character value of length one. This corresponds to the name in the covariance matrix of the \code{marketRisk}
to which the spread risk factor is mapped. This means that the risk factor change \eqn{\Delta S(1,j,r)}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"} will be assumed
to be modeled by the underlying normal random variable corresponding to \code{name} in the covariance matrix
(potentially scaled by \code{scale} if not \code{NULL}).}

\item{currency}{a character value of length one. The currency in which the underlying
\emph{"Fixed-Income-Assets oder Versicherungsverpflichtungen"} is valuated.
This refers to the currency corresponding to the index \code{j}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"} (version 31.1.2018).}

\item{rating}{a character value of length one. The corresponding rating of the spread refering to
the index \code{r} at in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{scale}{a numeric value of length one. If not set \code{NULL},
this defines a scaled risk factor equal to \code{scale} times
the risk factor defined by \code{name} in the covariance matrix contained in \code{marketRisk}.
By default its value is \code{scale = NULL}.}
}
\value{
An S3 object, instance of the class spread.
}
\description{
Constructor for the
  S3 class spread. It allows to define a spread-type risk factor. This risk factor refers
  to the \emph{"Modell-Spread"} change \eqn{\Delta S(1,j,r)} for a certain index \code{rating} r and a certain
  \code{currency} j in the
  valuation function for \emph{"Fixed-Income-Assets und Versicherungsverpflichtungen"} at page 6
  in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\examples{
# constructing a non-scaled spread risk factor
# (assuming "AA_EUR_Spread" exists in marketRisk).

e <- spread(name     = "AA_EUR_Spread",
            rating   = "AA",
            currency = "EUR")
# constructing a scaled spread risk factor
# (assuming "AA_EUR_Spread" exists in marketRisk).

e <- spread(name     = "AA_EUR_Spread",
            rating   = "AA",
            currency = "EUR",
            scale    = 0.5)

}
