% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/participation-base.R
\name{participation}
\alias{participation}
\title{Constructing a Participation}
\usage{
participation(currency, value)
}
\arguments{
\item{currency}{character value of length one. The currency in which
the participation is expressed.}

\item{value}{positive numeric value of length one. The total value
of the participation. This must be expressed in the
same currency as \code{currency}.}
}
\value{
an S3 object, instance of the class participation.
}
\description{
\code{participation} is the constructor
  for the S3 class participation. It allows to build
  for a participation position.
}
\note{
Please note that combined with a portfolio, the participation should be provided
  in the base currency.
}
\examples{
# Creating new participations.
participation1 <- participation("USD", 1000)
participation2 <- participation("EUR", 2000)

}
\seealso{
\code{\link{summary.participation}}, \code{\link{print.participation}}.
}
