% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sstModel-simulation.R
\name{compute.sstModel}
\alias{compute.sstModel}
\title{Compute a sstModel}
\usage{
\method{compute}{sstModel}(object, nsim, seed = NULL,
  nested.market.computations = F, ...)
}
\arguments{
\item{object}{S3 object of class sstModel.}

\item{nsim}{strictly positive integer value of length one. The number
of simulations.}

\item{seed}{positive integer value of length one. The seed for
reproducibility.}

\item{nested.market.computations}{logical value of length one, by default set
to \code{FALSE}. Should the market items valuations be nested (and saved) by item types?}

\item{...}{additional arguments.}
}
\value{
an S3 object, instance of the class \code{sstOutput}.
}
\description{
Compute method for the S3 class sstModel. It allows to compute (via Monte-Carlo simulations) all risks inherent
  to an insurer portfolio in the context of the Swiss Solvency Test (explanations on the model can be found
  in the FINMA technical document "SST-Marktrisiko und -Aggregation Technische Beschreibung".
  The output of is an S3 object of class sstOutput on which SST figures can be computed.
}
\seealso{
\code{\link{compute}}, \code{\link{sstModel}}.
}
