% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liability-base.R
\name{check.liability}
\alias{check.liability}
\title{Checking Consistency of an Insurance Liability
with a MarketRisk}
\usage{
\method{check}{liability}(object, market.risk, ...)
}
\arguments{
\item{object}{S3 object of class liability.}

\item{market.risk}{S3 object of class marketRisk created using the constructor
\code{marketRisk}.}

\item{...}{additional arguments.}
}
\value{
a logical value, is the liability consistent with the marketRisk?
}
\description{
\code{check} is a generic S3 method for S3 classes inheriting
  from item. It is a logical method checking if the item is well defined
  with respect to a risk (i.e. that all information necessary for valuating
  the item is available).
}
\seealso{
\code{\link{check}}, \code{\link{liability}},
  \code{\link{marketRisk}}.
}
