% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_aggregate.R
\name{spm_aggregate}
\alias{spm_aggregate}
\alias{spm_aggregate,sspm_dataset,missing-method}
\alias{spm_aggregate,sspm_dataset,sspm_discrete_boundary-method}
\alias{spm_aggregate,sspm_fit,ANY-method}
\title{Aggregate a dataset or fit data variable based on a boundary}
\usage{
spm_aggregate(
  sspm_object,
  boundaries,
  level = "patch",
  type = "data",
  variable,
  fun,
  group_by = "spacetime",
  fill = FALSE,
  apply_to_df = FALSE,
  ...
)

\S4method{spm_aggregate}{sspm_dataset,missing}(
  sspm_object,
  boundaries,
  level = "patch",
  type = "data",
  variable,
  fun,
  group_by = "spacetime",
  fill = FALSE,
  apply_to_df = FALSE,
  ...
)

\S4method{spm_aggregate}{sspm_dataset,sspm_discrete_boundary}(
  sspm_object,
  boundaries,
  level = "patch",
  type = "data",
  variable,
  fun,
  group_by = "spacetime",
  fill = FALSE,
  apply_to_df = FALSE,
  ...
)

\S4method{spm_aggregate}{sspm_fit,ANY}(
  sspm_object,
  boundaries,
  level = "patch",
  type = "data",
  variable,
  fun,
  group_by = "spacetime",
  fill = FALSE,
  apply_to_df = FALSE,
  ...
)
}
\arguments{
\item{sspm_object}{\strong{[sspm_dataset or sspm_fit]} The dataset object.}

\item{boundaries}{\strong{[sspm_discrete_boundary]} The boundaries object
(optionnal).}

\item{level}{\strong{[character]} The aggregation level, "patch" or
"boundary".}

\item{type}{\strong{[character]} The targeted type of aggregation, one of
"data" for base data or "smoothed" for smoothed data.}

\item{variable}{\strong{[character]} Variable to aggregate (ignored in case
\code{apply_to_df} is \code{TRUE}).}

\item{fun}{\strong{[function]} Function to use to aggregate data.}

\item{group_by}{\strong{[character]} One of \code{time}, \code{space} and \code{spacetime}.}

\item{fill}{\strong{[logical OR numeric OR function]} Whether to complete the
incomplete cases, default to \code{FALSE} for no completion.}

\item{apply_to_df}{\strong{[logical]} Wether \code{fun} applied to  the data frame
group or to \code{variable}, default to \code{FALSE}.}

\item{...}{More arguments passed onto \code{fun}}
}
\value{
Updated \code{sspm_dataset} or \code{sspm_fit}.
}
\description{
Aggregate the data contained in a dataset or fit  based on the discretized
boundaries, using a function and a filling value.
}
\examples{
\dontrun{
spm_aggregate(sspm_object = catch,
              boundaries = spm_boundaries(biomass),
              variable = catch_variable,
              fun = fun, group_by = group_by,
              fill = fill, apply_to_df = apply_to_df,
              na.rm = TRUE, ...)
}

}
