% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sshist.R
\name{sshist}
\alias{sshist}
\title{Optimal Histogram Binning (Shimazaki-Shinomoto Method)}
\usage{
sshist(x, n_max = NULL, sn = 30)
}
\arguments{
\item{x}{A numeric vector of data. Missing values (NA) will be removed.}

\item{n_max}{An integer specifying the maximum number of bins to test.
If \code{NULL} (default), it is automatically determined based on data resolution
and sample size to prevent overfitting.}

\item{sn}{Integer. The number of shifts to use for averaging (default is 30).}
}
\value{
An object of class \code{"sshist"} containing:
\describe{
\item{opt_n}{The optimal number of bins.}
\item{opt_d}{The optimal bin width.}
\item{edges}{The sequence of break points for the optimal histogram.}
\item{cost}{A numeric vector of the cost function values.}
\item{n_tested}{The vector of N values tested.}
\item{data}{The original data (cleaned).}
}
}
\description{
Computes the optimal bin width and number of bins using the Shimazaki-Shinomoto
method. This implementation uses Rcpp for high performance and includes
shift-averaging to remove edge-position bias.
}
\examples{
# 1. Basic usage with base graphics
data(faithful)
res <- sshist(faithful$waiting)
plot(res)

# 2. Usage with ggplot2
if (requireNamespace("ggplot2", quietly = TRUE)) {
  library(ggplot2)
  df <- data.frame(waiting = faithful$waiting)

  ggplot(df, aes(x = waiting)) +
    geom_histogram(breaks = res$edges, fill = "lightblue", color = "black") +
    ggtitle(paste("Optimal Shimazaki-Shinomoto Bins (N =", res$opt_n, ")")) +
    theme_minimal()
}
}
\references{
Shimazaki, H. and Shinomoto, S., 2007. A method for selecting the bin size of a time histogram.
\emph{Neural Computation}, 19(6), pp.1503-1527.
}
