% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec.R
\name{ssh_exec}
\alias{ssh_exec}
\alias{ssh_exec_wait}
\alias{ssh_exec_internal}
\title{Execute Remote Command}
\usage{
ssh_exec_wait(
  session,
  command = "whoami",
  std_out = stdout(),
  std_err = stderr()
)

ssh_exec_internal(session, command = "whoami", error = TRUE)
}
\arguments{
\item{session}{ssh connection created with \code{\link[=ssh_connect]{ssh_connect()}}}

\item{command}{The command or script to execute}

\item{std_out}{callback function, filename, or connection object to handle stdout stream}

\item{std_err}{callback function, filename, or connection object to handle stderr stream}

\item{error}{automatically raise an error if the exit status is non-zero}
}
\description{
Run a command or script on the host while streaming stdout and stderr directly
to the client.
}
\details{
The \code{\link[=ssh_exec_wait]{ssh_exec_wait()}} function is the remote equivalent of the local \code{\link[sys:exec]{sys::exec_wait()}}.
It runs a command or script on the ssh server and streams stdout and stderr to the client
to a file or connection. When done it returns the exit status for the remotely executed command.

Similarly \code{\link[=ssh_exec_internal]{ssh_exec_internal()}} is a small wrapper analogous to \code{\link[sys:exec]{sys::exec_internal()}}.
It buffers all stdout and stderr output into a raw vector and returns it in a list along with
the exit status. By default this function raises an error if the remote command was unsuccessful.
}
\examples{
\dontrun{
session <- ssh_connect("dev.opencpu.org")
ssh_exec_wait(session, command = c(
  'curl -O https://cran.r-project.org/src/contrib/jsonlite_1.5.tar.gz',
  'R CMD check jsonlite_1.5.tar.gz',
  'rm -f jsonlite_1.5.tar.gz'
))
ssh_disconnect(session)}
}
\seealso{
Other ssh: 
\code{\link{scp}},
\code{\link{ssh_connect}()},
\code{\link{ssh_credentials}},
\code{\link{ssh_tunnel}()}
}
\concept{ssh}
