% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mkdir.remote}
\alias{mkdir.remote}
\title{Creates a remote directory with the specified group ownership and permissions.}
\usage{
mkdir.remote(path, user.group = NULL, remote = "",
  permissions = c("g+rwx", "g+rx", "go-w", "go-rwx", "-"))
}
\arguments{
\item{path}{Directory path. If using \code{remote}, this should be a full path or
a path relative to the user's home directory.}

\item{user.group}{The user group. If NULL, the default group is used.}

\item{remote}{Remote machine specification for ssh, in format such as \code{user@server} that does not
require interactive password entry. For local execution, pass an empty string "" (default).}

\item{permissions}{The group permissions on the directory. Default is 'rwx'.}
}
\description{
If the directory already exists, attempts to set the group ownership to the
\code{user.group}. The allowed group permissions are one of
\code{c("g+rwx", "g+rx", "go-w", "go-rwx")}, or \code{"-"}. The value
\code{"-"} means "don't change permissions".
}
\note{
This may not work on Windows.
}

