% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper.R
\name{transform_ensembl_2_entrez}
\alias{transform_ensembl_2_entrez}
\title{Function to Transform ENSEMBL ID to ENTREZ ID}
\usage{
transform_ensembl_2_entrez(Data)
}
\arguments{
\item{Data}{Data matrix of gene expressions with gene ensembl ID as row names and columns corresponding to different samples.}
}
\value{
Data matrix of gene expressions with ENSEMBL ID as row names and columns corresponding to samples will be return.
}
\description{
This function is to uniform gene ID types in data matrices, i.e., from ENSEMBL ID to ENTREZ ID.
}
\details{
Since gene IDs in data matrices from different sources may be in different formats (ensembl ID or entrez ID),
this function is to transform the gene IDs in the data matrix from ensembl ID to entrez ID, to assist the following
single sample directional gene set analysis.
}
\examples{
transform_ensembl_2_entrez(Data = data_matrix)


}
