% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc.R
\name{sparsePCAloc}
\alias{sparsePCAloc}
\title{Calculate Sparse Principle Components}
\usage{
sparsePCAloc(
  eta,
  gamma,
  COVS,
  cor = FALSE,
  rho = NULL,
  k = NULL,
  eps_threshold = NULL,
  eps_ADMM = 1e-04,
  n_max = 200,
  eps_root = 0.1,
  maxiter_root = 50,
  increase_rho = list(TRUE, 100, 1),
  convergence_plot = TRUE,
  starting_value = NULL,
  adjust_eta = TRUE,
  trace = TRUE
)
}
\arguments{
\item{eta}{numeric, degree of sparsity.}

\item{gamma}{numeric, distribution of sparsity.}

\item{COVS}{list of covariance or correlation matrices.}

\item{cor}{logical, if starting value for correlation or covariance matrices should be used.}

\item{rho}{numeric bigger than zero, penalty for ADMM.}

\item{k}{number of components to calculate.}

\item{eps_threshold}{tolerance for thresholding.}

\item{eps_ADMM}{tolerance for ADMM convergence.}

\item{n_max}{number of maximal iterations.}

\item{eps_root}{tolerance for root finder.}

\item{maxiter_root}{maximal number of iterations for root finder.}

\item{increase_rho}{list with entries for stable convergence. See Details.}

\item{convergence_plot}{logical, if convergence plot should be displayed.}

\item{starting_value}{optional given starting value.}

\item{adjust_eta}{logical, if eta should be adjusted by the variance.}

\item{trace}{logical, if messages should be displayed.}
}
\value{
An object of class \code{"PCAloc"} containing the following elements:\tabular{ll}{
   \code{PC} \tab Matrix of dimension Np x k of stacked loading vectors.  \cr
   \tab \cr
   \code{p} \tab Number of variables. \cr
   \tab \cr
   \code{N} \tab Number of neighborhoods. \cr
   \tab \cr
   \code{k} \tab Number of components. \cr
   \tab \cr
   \code{COVS} \tab List of covariance matrices sorted by neighborhood. \cr
   \tab \cr
   \code{gamma} \tab Sparsity distribution. \cr
   \tab \cr
   \code{eta} \tab Amount of sparsity. \cr
   \tab \cr
   \code{converged} \tab Logical, if ADMM converged with given specifications. \cr
   \tab \cr
   \code{n_steps} \tab Number of steps used. \cr
   \tab \cr
   \code{summary} \tab Description of result per component. \cr
   \tab \cr
   \code{residuals} \tab Primary and secondary residuals. \cr
   \tab \cr
}
}
\description{
Calculate Sparse Principle Components
}
\details{
The input \code{increase_rho} consists of a logical indicating if rho should be adjusted
if algorithm did not converged within the given maximal number of iterations. Two integers specify the
maximal \code{rho} that is allowed and the step size.
}
\examples{
C1 = diag(c(1.1, 0.9, 0.6))
C2 = matrix(c(1.1, 0.1, -0.1,
              0.1, 1.0, -0.2,
             -0.1, -0.2, 0.7), ncol = 3)
C3 = (C1 + C2)/2

sparsePCAloc(eta = 1, gamma = 0.5, cor = FALSE, COVS = list(C1, C2, C3),
             n_max = 100, increase_rho = list(FALSE, 100, 1))

}
