% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{interact}
\alias{interact}
\title{Create interaction terms to group by when summarizing}
\usage{
interact(...)
}
\arguments{
\item{...}{variables to group by. All types of tbls accept variable names, and
most will also accept functions of variables (though some database-backed
tbls do not allow creating variables).}
}
\value{
A vector of type \code{\link{srvyr_interaction}}, which is generally
expected to be automatically split apart.
}
\description{
Allows multiple grouping by multiple variables as if they were a single
variable, which allows calculating proportions that sum to 100% across
more than a single grouping variable with \code{survey_mean}.
}
\details{
Behind the scenes, this function creates a special column type that is
split back into the component columns automatically by \code{summarize}.
}
\examples{
data(api, package = "survey")

dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

# The sum of the whole prop column is equal to 100\%
dstrata \%>\%
  group_by(interact(stype, awards)) \%>\%
  summarize(prop = survey_mean())

# But if you didn't interact, the sum of each stype's prop is 100\%
dstrata \%>\%
  group_by(stype, awards) \%>\%
  summarize(prop = survey_mean())
}
